% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program SinewaveGratingGabor.m
c = 0.25;            % contrast of the Gabor
f = 1/32;            % spatial frequency in 1/pixels
t = 35*pi/180;       % tilt of 35 degrees into radians
s = 24;              % standard deviation of the spatial 
                     % window of the Gabor
[x,  y] = meshgrid(-128:127, 128:-1:-127);
M1 = uint8(127*(1 + c*sin(2.0*pi*f*(y*sin(t) + x*cos(t)))));
        % uint8 converts the elements of the array into unsigned 
        % 8-bit integers. Values outside this range are mapped 
        % to 0 or 255.
showImage(M1,  'grayscale'); 
M2 = uint8(127*(1 + c*sin(2.0*pi*f*(y*sin(t) + x*cos(t))) ...
     .*exp(-(x.^2 + y.^2)/2/s^2)));
showImage(M2,   'grayscale'); 
